//This file is part of LiveCoding1. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file LiveCoding1.help

//encapsulation of LCObject

//to be overridden in other classes

//can remove pauseifnoclock since bbcuts safe
//other functions just return their internal pause variable- ie PauseStream responding to pause. 
//set to true or false by LiveCoding1 object 

//two functions, one for immediate allocations and one for starting to play? 
//array returned from first function is passed to second

LCObject
{
var <>name, <>func; //, <>loc;
var obj, source;

*new
{
arg name, func;		//third argument for stuff that must be done immediately too complex-
					//can always do in code outside of the class anyway ie ~stuffnow= {}.value;
					//LCO(\name, {using ~stuffnow }) 

^super.new.name_(name).func_(func); //.loc_(InterpreterLocation.new);
}

makeobj{
arg index, group, tc, tnum;

^func.value(index,Group.head(group), tc, tnum);
}

play{arg index, group, tc,tnum;

//pass in subgroup of group because this object may otherwise deallocate the group! 
//safe to attack subgroup...

source= this.makeobj(index,group,tc,tnum);

Post << [not(source.isKindOf(ArrayedCollection))] <<nl;

if(source.notNil,
{
if(not(source.isKindOf(ArrayedCollection)),{obj= [{arg bool;  source.run(bool)},{source.stop}];}, {obj=source;});
},{obj= [{"pausenil".postln;},{"killnil".postln;}]});

}

kill
{

//if(obj.respondsTo(\kill),)
if(obj.size>1, {obj.at(1).value;});	//in case of nil here
obj=nil;
}

run
{
arg bool= true;

if(obj.notNil,{
obj.at(0).value(bool);
});

}

pause
{
arg val;

this.run(if(val==1, true, false));
}

}

//just makes a Synth
LCO : LCObject {

makeobj
{
arg index, group, tc;
var synth;

synth= SynthDef(name, {
var funcout;

funcout=func.value;

//silent if erroneous
if(not(funcout.isKindOf(UGen) || funcout.isKindOf(ArrayedCollection)),{funcout= SinOsc.ar(1,0,0.00001)});

//if mono make stereo
if(funcout.size<2,{funcout=Pan2.ar(funcout,0.0)});

Out.ar(index, funcout)

}).play(group);

^[{arg bool; synth.run(bool)},{synth.free;}]
}


}


//singular thing that responds to kill and run
//problem if have function code that is a clock used to spawn synths
LCOK : LCObject {}

//bbcutter live coding object
LBBC : LCOK
{

/*
makemidi
{
arg synthproc;

^synthproc;
}
*/

makeobj
{
arg index, group, tc;
var synthproc;
//pass in subgroup of group because this object may otherwise deallocate the group! 
//safe to attack subgroup...

synthproc= func.value(index,group,tc);

//synthproc.put(0,this.makemidi(synthproc.at(0))); 

^BBCut(BBCG(synthproc.at(0), Group.head(group),index), synthproc.at(1),
//if made own tempoclock
if(synthproc.size>2,{synthproc.at(2)},{tc})).play;
}

}


//LBBCM	live coded bbcut with midi out (av protocol)
//bbcutter live coding object
LBBCM : LCOK
{
classvar <>midiout;
var <>inst;

*new
{
arg name, func, instance;

^super.new(name, func).inst_(instance);
}

/*
makemidi
{
arg syn;
var bbcm;

bbcm= BBCSMIDIOut(inst, midiout);

^if(syn.isKindOf(Array), {syn++[bbcm]},{[syn, bbcm]});
}
*/

makeobj
{
arg index, group, tc,tnum;
var synthproc, syn, bbcm;
//pass in subgroup of group because this object may otherwise deallocate the group! 
//safe to attack subgroup...

synthproc= func.value(index,group,tc);

syn= synthproc.at(0);

//used to be instance
bbcm= BBCSMIDIOut(tnum, midiout);

syn= if(syn.isKindOf(Array), {syn++[bbcm]},{[syn, bbcm]});

^BBCut(BBCG(syn, Group.head(group),index), synthproc.at(1),
//if made own tempoclock
if(synthproc.size>2,{synthproc.at(2)},{tc})).play;
}

}


//LBBCM	live coded bbcut with midi out (av protocol)
//bbcutter live coding object
LBBCO : LCOK
{
classvar <>na;
var <>inst;

*new
{
arg name, func, instance=0;

^super.new(name, func).inst_(instance);
}

makeobj
{
arg index, group, tc, tnum;
var synthproc, syn, bbco;
//pass in subgroup of group because this object may otherwise deallocate the group! 
//safe to attack subgroup...

synthproc= func.value(index,group,tc);

syn= synthproc.at(0);

//used to be inst
bbco= BBCSOSCOut(tnum, na);

syn= if(syn.isKindOf(Array), {syn++[bbco]},{[syn, bbco]});

^BBCut(BBCG(syn, Group.head(group),index), synthproc.at(1),
//if made own tempoclock
if(synthproc.size>2,{synthproc.at(2)},{tc})).play;
}

}


LCOSpawn : LCOK
{
var <>ntfunc, <>count;

*new
{
arg name, func, ntfunc;

^super.new(name,func).ntfunc_(ntfunc ? 1.0).count_(0);
}


makeobj
{
arg index, group, tc;
var run, end;

run=false;
end=false;

tc.schedAbs(tc.elapsedBeats, {
if(run,{
count=count+1;
func.value(index, group, tc, count);});

if(end,{nil},{ntfunc.value})
});

^[{arg bool; run=bool;},{run=false; end=true;}]
}

}





LCOSpawnSynth : LCOSpawn {

makeobj{arg index, group, tc;
var run, end,funcout;

run=true;
end=false;

tc.schedAbs(tc.elapsedBeats,{

if(run,{

count=count+1;

SynthDef(name, 
{

funcout=func.value(count);

//silent if erroneous
if(not(funcout.isKindOf(UGen) || funcout.isKindOf(ArrayedCollection)),{funcout= SinOsc.ar(1,0,0.00001)});

//if mono make stereo
if(funcout.size<2,{funcout=Pan2.ar(funcout,0.0)});

Out.ar(index, funcout)

}).play(group);

});

if(end,nil,{ntfunc.value});
});

^[{arg bool; bool.postln; run=bool;},{run=false; end=true;}]
}

}

